/**
 * Marlin 3D Printer Firmware
 * Copyright (C) 2016 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (C) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

/**
 * Animated boot screen example
 */

#define ANIMATED_BOOTSCREEN
#define CUSTOM_BOOTSCREEN_FRAME_TIME 100  // (ms)

#define CUSTOM_BOOTSCREEN_BMPWIDTH   128
#define CUSTOM_BOOTSCREEN_TIMEOUT   2500  // (ms)

const unsigned char custom_start_bmp[] PROGMEM = {
  B00011111,B11111111,B11111111,B11111111,B11111111,B11001111,B11111111,B11111111,B11111111,B10000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
  B00001000,B00000000,B00000000,B00000000,B00000000,B11011000,B00000000,B00000000,B00000001,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
  B00001000,B00000000,B00000000,B00000000,B00000000,B10010000,B00000000,B00000000,B00000011,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
  B00000100,B00000000,B00000000,B00000000,B00000001,B10100000,B00000000,B00000000,B00000010,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
  B00000110,B00000000,B00000000,B00000000,B00000001,B01100000,B00000000,B00000000,B00000100,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
  B00000010,B00000000,B00000000,B00000000,B00000010,B01000000,B00000000,B00000000,B00000100,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
  B00000001,B11111111,B10000000,B01111111,B11111110,B11000000,B00000000,B00000000,B00001000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
  B00000000,B11111111,B11000000,B01111111,B00001000,B10000001,B11100000,B00111000,B00011000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
  B00000000,B00000000,B00100000,B01000000,B00000001,B00000011,B01000000,B01011000,B00010000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
  B00000000,B11111111,B10110000,B00100111,B11111001,B00000010,B01000000,B10010000,B00100000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
  B00000000,B01000000,B11010000,B00110110,B00001101,B10000110,B10000000,B10100000,B00100010,B00010000,B00000010,B10000000,B11110000,B00000000,B00000000,B00000000,
  B00000000,B01100000,B01001000,B00010010,B00000100,B10000101,B10000001,B00100000,B01000011,B00110000,B00000010,B00000000,B00111000,B00000000,B00000000,B00000000,
  B00000000,B00100000,B00101000,B00001011,B00000010,B11001001,B00000011,B01000000,B11000011,B00110011,B10011010,B10111000,B00011000,B10001000,B00100010,B00000000,
  B00000000,B00110000,B00100100,B00001001,B00000011,B01001011,B00000010,B11000000,B10000011,B00110000,B10010010,B10100100,B00011000,B01110000,B00011100,B00000000,
  B00000000,B00010000,B00010110,B00000100,B10000001,B00110010,B00000110,B10000001,B10000010,B11010011,B10010010,B10100100,B00110000,B00100000,B00001000,B00000000,
  B00000000,B00001000,B00011010,B00000110,B10000001,B10110100,B00000101,B10000001,B00000010,B11010100,B10010010,B10100100,B01110000,B01110000,B00011100,B00000000,
  B00000000,B00001100,B00001011,B00000010,B01000000,B10000100,B00001001,B00000010,B00000010,B00010011,B10010010,B10100100,B11111010,B10001010,B10100010,B00000000,
  B00000000,B00000100,B00001101,B00000011,B01100000,B01001000,B00001010,B00000110,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
  B00000000,B00000110,B00000100,B10000001,B00100000,B01111000,B00010010,B00000100,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
  B00000000,B00000010,B00000010,B10000000,B10110000,B00110000,B00110100,B00001100,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
  B00000000,B00000001,B00000010,B01000000,B10010000,B00000000,B00101100,B00001000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
  B00000000,B00000001,B00000001,B01100000,B01001000,B00000000,B01001000,B00010000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
  B00000000,B00000000,B10000001,B10100000,B01101000,B00000000,B01011000,B00010001,B11110000,B00000000,B00000000,B00010000,B00000000,B00000000,B00000000,B00000000,
  B00000000,B00000000,B11000000,B10110000,B00100100,B00000000,B10010000,B00100000,B01000000,B00000000,B00000000,B00010000,B00000000,B00000000,B00000000,B00000000,
  B00000000,B00000000,B01000000,B11010000,B00110110,B00000001,B10100000,B01100000,B01000011,B00110111,B00011100,B11110011,B10000000,B00000000,B00000000,B00000000,
  B00000000,B00000000,B01100000,B01001000,B00010010,B00000001,B01100000,B01000000,B01000100,B10100100,B10000101,B10010100,B01000000,B00000000,B00000000,B00000000,
  B00000000,B00000000,B00100000,B00101100,B00001011,B00000001,B01000000,B11000000,B01000100,B10100100,B10011101,B00010100,B01000000,B00000000,B00000000,B00000000,
  B00000000,B00000000,B00010000,B00110100,B00001001,B00000001,B01000000,B10000000,B01000100,B10100100,B10100101,B00010100,B01000000,B00000000,B00000000,B00000000,
  B00000000,B00000000,B00011000,B00010110,B00000100,B10000001,B00100001,B00000000,B01000011,B00100100,B10011100,B11110011,B10000000,B00000000,B00000000,B00000000,
  B00000000,B00000000,B00001000,B00011010,B00000110,B10000001,B10100011,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
  B00000000,B00000000,B00001100,B00001001,B00000010,B01000000,B10010010,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
  B00000000,B00000000,B00000100,B00000101,B00000011,B01100000,B01011110,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
  B00000000,B00000000,B00000010,B00000100,B10000001,B00100000,B01101100,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
  B00000000,B00000000,B00000010,B00000010,B11000000,B10110000,B00100000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
  B00000000,B00000000,B00000001,B00000011,B01000000,B10010000,B00110000,B11110000,B10010000,B10000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
  B00000000,B00000000,B00000001,B10000001,B01100000,B01011000,B00010000,B10000000,B10000100,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
  B00000000,B00000000,B00000000,B10000001,B10100000,B11010000,B00110000,B10000111,B10011110,B10111001,B11000000,B00000000,B00000000,B00000000,B00000000,B00000000,
  B00000000,B00000000,B00000000,B11000000,B10010000,B10010000,B00100000,B11101100,B10010100,B11000101,B00100000,B00000000,B00000000,B00000000,B00000000,B00000000,
  B00000000,B00000000,B00000000,B01000000,B01011001,B00100000,B01000000,B10001000,B10010100,B11000101,B00100000,B00000000,B00000000,B00000000,B00000000,B00000000,
  B00000000,B00000000,B00000000,B00100000,B01001011,B01100000,B01000000,B10001100,B10010100,B11000101,B00100000,B00000000,B00000000,B00000000,B00000000,B00000000,
  B00000000,B00000000,B00000000,B00110000,B00101110,B01000000,B10000000,B11110111,B10010110,B10111001,B00100000,B00000000,B00000000,B00000000,B00000000,B00000000,
  B00000000,B00000000,B00000000,B00010000,B00110110,B11000001,B10000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
  B00000000,B00000000,B00000000,B00011000,B00010000,B10000001,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
  B00000000,B00000000,B00000000,B00001000,B00001001,B00000011,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
  B00000000,B00000000,B00000000,B00001100,B00001001,B00000010,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
  B00000000,B00000000,B00000000,B00000100,B00000110,B00000110,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
  B00000000,B00000000,B00000000,B00000010,B00000110,B00000100,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
  B00000000,B00000000,B00000000,B00000011,B00000000,B00001000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
  B00000000,B00000000,B00000000,B00000001,B00000000,B00001000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
  B00000000,B00000000,B00000000,B00000001,B10000000,B00010000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
  B00000000,B00000000,B00000000,B00000000,B10000000,B00110000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
  B00000000,B00000000,B00000000,B00000000,B01000000,B00100000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
  B00000000,B00000000,B00000000,B00000000,B01000000,B01100000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
  B00000000,B00000000,B00000000,B00000000,B00100000,B01000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
  B00000000,B00000000,B00000000,B00000000,B00110000,B10000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
  B00000000,B00000000,B00000000,B00000000,B00011001,B10000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
  B00000000,B00000000,B00000000,B00000000,B00001110,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000
};

#if ENABLED(ANIMATED_BOOTSCREEN)

  const unsigned char custom_start_bmp1[] PROGMEM = {
    B11111001,B11111111,B11111111,B11111111,B11110000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00011011,B00000000,B00000000,B00000000,B00100000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00010010,B00000000,B00000000,B00000000,B01100000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00110100,B00000000,B00000000,B00000000,B01000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00101100,B00000000,B00000000,B00000000,B10000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B01001000,B00000000,B00000000,B00000000,B10000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B11011000,B00000000,B00000000,B00000001,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00010000,B00111100,B00000111,B00000011,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00100000,B01101000,B00001011,B00000010,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00100000,B01001000,B00010010,B00000100,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B10110000,B11010000,B00010100,B00000100,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B10010000,B10110000,B00100100,B00001000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B01011001,B00100000,B01101000,B00011000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B01101001,B01100000,B01011000,B00010000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00100110,B01000000,B11010000,B00110000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00110110,B10000000,B10110000,B00100000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00010000,B10000001,B00100000,B01000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00001001,B00000001,B01000000,B11000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00001111,B00000010,B01000000,B10000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000110,B00000110,B10000001,B10000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000101,B10000001,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00001001,B00000010,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00001011,B00000010,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B10000000,B00010010,B00000100,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B11000000,B00110100,B00001100,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B01000000,B00101100,B00001000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B01100000,B00101000,B00011000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00100000,B00101000,B00010000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B10010000,B00100100,B00100000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B11010000,B00110100,B01100000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B01001000,B00010010,B01000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B01101100,B00001011,B11000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00100100,B00001101,B10000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00010110,B00000100,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00010010,B00000110,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00001011,B00000010,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00011010,B00000110,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00010010,B00000100,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00100100,B00001000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B01101100,B00001000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B11001000,B00010000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B11011000,B00110000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00010000,B00100000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00100000,B01100000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00100000,B01000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B11000000,B11000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B11000000,B10000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000001,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000001,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000010,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000110,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000100,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00001100,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00001000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00010000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00110000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B11000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000
  };

  const unsigned char custom_start_bmp2[] PROGMEM = {
    B00011111,B11111111,B11111111,B11111111,B11111111,B11001111,B11111111,B11111111,B11111111,B10000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00001000,B00000000,B00000000,B00000000,B00000000,B11011000,B00000000,B00000000,B00000001,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00001000,B00000000,B00000000,B00000000,B00000000,B10010000,B00000000,B00000000,B00000011,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000100,B00000000,B00000000,B00000000,B00000001,B10100000,B00000000,B00000000,B00000010,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000110,B00000000,B00000000,B00000000,B00000001,B01100000,B00000000,B00000000,B00000100,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000010,B00000000,B00000000,B00000000,B00000010,B01000000,B00000000,B00000000,B00000100,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000001,B11111111,B10000000,B01111111,B11111110,B11000000,B00000000,B00000000,B00001000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B11111111,B11000000,B01111111,B00001000,B10000001,B11100000,B00111000,B00011000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00100000,B01000000,B00000001,B00000011,B01000000,B01011000,B00010000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B11111111,B10110000,B00100111,B11111001,B00000010,B01000000,B10010000,B00100000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B01000000,B11010000,B00110110,B00001101,B10000110,B10000000,B10100000,B00100000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B01100000,B01001000,B00010010,B00000100,B10000101,B10000001,B00100000,B01000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00100000,B00101000,B00001011,B00000010,B11001001,B00000011,B01000000,B11000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00110000,B00100100,B00001001,B00000011,B01001011,B00000010,B11000000,B10000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00010000,B00010110,B00000100,B10000001,B00110010,B00000110,B10000001,B10000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00001000,B00011010,B00000110,B10000001,B10110100,B00000101,B10000001,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00001100,B00001011,B00000010,B01000000,B10000100,B00001001,B00000010,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000100,B00001101,B00000011,B01100000,B01001000,B00001010,B00000110,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000110,B00000100,B10000001,B00100000,B01111000,B00010010,B00000100,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000010,B00000010,B10000000,B10110000,B00110000,B00110100,B00001100,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000001,B00000010,B01000000,B10010000,B00000000,B00101100,B00001000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000001,B00000001,B01100000,B01001000,B00000000,B01001000,B00010000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B10000001,B10100000,B01101000,B00000000,B01011000,B00010000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B11000000,B10110000,B00100100,B00000000,B10010000,B00100000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B01000000,B11010000,B00110110,B00000001,B10100000,B01100000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B01100000,B01001000,B00010010,B00000001,B01100000,B01000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00100000,B00101100,B00001011,B00000001,B01000000,B11000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00010000,B00110100,B00001001,B00000001,B01000000,B10000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00011000,B00010110,B00000100,B10000001,B00100001,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00001000,B00011010,B00000110,B10000001,B10100011,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00001100,B00001001,B00000010,B01000000,B10010010,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000100,B00000101,B00000011,B01100000,B01011110,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000010,B00000100,B10000001,B00100000,B01101100,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000010,B00000010,B11000000,B10110000,B00100000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000001,B00000011,B01000000,B10010000,B00110000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000001,B10000001,B01100000,B01011000,B00010000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B10000001,B10100000,B11010000,B00110000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B11000000,B10010000,B10010000,B00100000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B01000000,B01011001,B00100000,B01000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00100000,B01001011,B01100000,B01000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00110000,B00101110,B01000000,B10000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00010000,B00110110,B11000001,B10000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00011000,B00010000,B10000001,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00001000,B00001001,B00000011,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00001100,B00001001,B00000010,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00000100,B00000110,B00000110,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00000010,B00000110,B00000100,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00000011,B00000000,B00001000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00000001,B00000000,B00001000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00000001,B10000000,B00010000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00000000,B10000000,B00110000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00000000,B01000000,B00100000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00000000,B01000000,B01100000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00000000,B00100000,B01000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00000000,B00110000,B10000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00000000,B00011001,B10000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00000000,B00001110,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000
  };

  const unsigned char custom_start_bmp3[] PROGMEM = {
    B00011111,B11111111,B11111111,B11111111,B11111111,B11001111,B11111111,B11111111,B11111111,B10000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00001000,B00000000,B00000000,B00000000,B00000000,B11011000,B00000000,B00000000,B00000001,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00001000,B00000000,B00000000,B00000000,B00000000,B10010000,B00000000,B00000000,B00000011,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000100,B00000000,B00000000,B00000000,B00000001,B10100000,B00000000,B00000000,B00000010,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000110,B00000000,B00000000,B00000000,B00000001,B01100000,B00000000,B00000000,B00000100,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000010,B00000000,B00000000,B00000000,B00000010,B01000000,B00000000,B00000000,B00000100,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000001,B11111111,B10000000,B01111111,B11111110,B11000000,B00000000,B00000000,B00001000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B11111111,B11000000,B01111111,B00001000,B10000001,B11100000,B00111000,B00011000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00100000,B01000000,B00000001,B00000011,B01000000,B01011000,B00010000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B11111111,B10110000,B00100111,B11111001,B00000010,B01000000,B10010000,B00100000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B01000000,B11010000,B00110110,B00001101,B10000110,B10000000,B10100000,B00100010,B00010000,B00000010,B10000000,B11110000,B00000000,B00000000,B00000000,
    B00000000,B01100000,B01001000,B00010010,B00000100,B10000101,B10000001,B00100000,B01000011,B00110000,B00000010,B00000000,B00111000,B00000000,B00000000,B00000000,
    B00000000,B00100000,B00101000,B00001011,B00000010,B11001001,B00000011,B01000000,B11000011,B00110011,B10011010,B10111000,B00011000,B10001000,B00100010,B00000000,
    B00000000,B00110000,B00100100,B00001001,B00000011,B01001011,B00000010,B11000000,B10000011,B00110000,B10010010,B10100100,B00011000,B01110000,B00011100,B00000000,
    B00000000,B00010000,B00010110,B00000100,B10000001,B00110010,B00000110,B10000001,B10000010,B11010011,B10010010,B10100100,B00110000,B00100000,B00001000,B00000000,
    B00000000,B00001000,B00011010,B00000110,B10000001,B10110100,B00000101,B10000001,B00000010,B11010100,B10010010,B10100100,B01110000,B01110000,B00011100,B00000000,
    B00000000,B00001100,B00001011,B00000010,B01000000,B10000100,B00001001,B00000010,B00000010,B00010011,B10010010,B10100100,B11111010,B10001010,B10100010,B00000000,
    B00000000,B00000100,B00001101,B00000011,B01100000,B01001000,B00001010,B00000110,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000110,B00000100,B10000001,B00100000,B01111000,B00010010,B00000100,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000010,B00000010,B10000000,B10110000,B00110000,B00110100,B00001100,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000001,B00000010,B01000000,B10010000,B00000000,B00101100,B00001000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000001,B00000001,B01100000,B01001000,B00000000,B01001000,B00010000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B10000001,B10100000,B01101000,B00000000,B01011000,B00010000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B11000000,B10110000,B00100100,B00000000,B10010000,B00100000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B01000000,B11010000,B00110110,B00000001,B10100000,B01100000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B01100000,B01001000,B00010010,B00000001,B01100000,B01000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00100000,B00101100,B00001011,B00000001,B01000000,B11000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00010000,B00110100,B00001001,B00000001,B01000000,B10000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00011000,B00010110,B00000100,B10000001,B00100001,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00001000,B00011010,B00000110,B10000001,B10100011,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00001100,B00001001,B00000010,B01000000,B10010010,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000100,B00000101,B00000011,B01100000,B01011110,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000010,B00000100,B10000001,B00100000,B01101100,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000010,B00000010,B11000000,B10110000,B00100000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000001,B00000011,B01000000,B10010000,B00110000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000001,B10000001,B01100000,B01011000,B00010000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B10000001,B10100000,B11010000,B00110000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B11000000,B10010000,B10010000,B00100000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B01000000,B01011001,B00100000,B01000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00100000,B01001011,B01100000,B01000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00110000,B00101110,B01000000,B10000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00010000,B00110110,B11000001,B10000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00011000,B00010000,B10000001,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00001000,B00001001,B00000011,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00001100,B00001001,B00000010,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00000100,B00000110,B00000110,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00000010,B00000110,B00000100,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00000011,B00000000,B00001000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00000001,B00000000,B00001000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00000001,B10000000,B00010000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00000000,B10000000,B00110000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00000000,B01000000,B00100000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00000000,B01000000,B01100000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00000000,B00100000,B01000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00000000,B00110000,B10000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00000000,B00011001,B10000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00000000,B00001110,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000
  };

  const unsigned char custom_start_bmp4[] PROGMEM = {
    B00011111,B11111111,B11111111,B11111111,B11111111,B11001111,B11111111,B11111111,B11111111,B10000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00001000,B00000000,B00000000,B00000000,B00000000,B11011000,B00000000,B00000000,B00000001,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00001000,B00000000,B00000000,B00000000,B00000000,B10010000,B00000000,B00000000,B00000011,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000100,B00000000,B00000000,B00000000,B00000001,B10100000,B00000000,B00000000,B00000010,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000110,B00000000,B00000000,B00000000,B00000001,B01100000,B00000000,B00000000,B00000100,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000010,B00000000,B00000000,B00000000,B00000010,B01000000,B00000000,B00000000,B00000100,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000001,B11111111,B10000000,B01111111,B11111110,B11000000,B00000000,B00000000,B00001000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B11111111,B11000000,B01111111,B00001000,B10000001,B11100000,B00111000,B00011000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00100000,B01000000,B00000001,B00000011,B01000000,B01011000,B00010000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B11111111,B10110000,B00100111,B11111001,B00000010,B01000000,B10010000,B00100000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B01000000,B11010000,B00110110,B00001101,B10000110,B10000000,B10100000,B00100010,B00010000,B00000010,B10000000,B11110000,B00000000,B00000000,B00000000,
    B00000000,B01100000,B01001000,B00010010,B00000100,B10000101,B10000001,B00100000,B01000011,B00110000,B00000010,B00000000,B00111000,B00000000,B00000000,B00000000,
    B00000000,B00100000,B00101000,B00001011,B00000010,B11001001,B00000011,B01000000,B11000011,B00110011,B10011010,B10111000,B00011000,B10001000,B00100010,B00000000,
    B00000000,B00110000,B00100100,B00001001,B00000011,B01001011,B00000010,B11000000,B10000011,B00110000,B10010010,B10100100,B00011000,B01110000,B00011100,B00000000,
    B00000000,B00010000,B00010110,B00000100,B10000001,B00110010,B00000110,B10000001,B10000010,B11010011,B10010010,B10100100,B00110000,B00100000,B00001000,B00000000,
    B00000000,B00001000,B00011010,B00000110,B10000001,B10110100,B00000101,B10000001,B00000010,B11010100,B10010010,B10100100,B01110000,B01110000,B00011100,B00000000,
    B00000000,B00001100,B00001011,B00000010,B01000000,B10000100,B00001001,B00000010,B00000010,B00010011,B10010010,B10100100,B11111010,B10001010,B10100010,B00000000,
    B00000000,B00000100,B00001101,B00000011,B01100000,B01001000,B00001010,B00000110,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000110,B00000100,B10000001,B00100000,B01111000,B00010010,B00000100,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000010,B00000010,B10000000,B10110000,B00110000,B00110100,B00001100,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000001,B00000010,B01000000,B10010000,B00000000,B00101100,B00001000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000001,B00000001,B01100000,B01001000,B00000000,B01001000,B00010000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B10000001,B10100000,B01101000,B00000000,B01011000,B00010001,B11110000,B00000000,B00000000,B00010000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B11000000,B10110000,B00100100,B00000000,B10010000,B00100000,B01000000,B00000000,B00000000,B00010000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B01000000,B11010000,B00110110,B00000001,B10100000,B01100000,B01000011,B00110111,B00011100,B11110011,B10000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B01100000,B01001000,B00010010,B00000001,B01100000,B01000000,B01000100,B10100100,B10000101,B10010010,B01000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00100000,B00101100,B00001011,B00000001,B01000000,B11000000,B01000100,B10100100,B10011101,B00010100,B01000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00010000,B00110100,B00001001,B00000001,B01000000,B10000000,B01000100,B10100100,B10100101,B00010010,B01000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00011000,B00010110,B00000100,B10000001,B00100001,B00000000,B01000011,B00100100,B10011100,B11110011,B10000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00001000,B00011010,B00000110,B10000001,B10100011,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00001100,B00001001,B00000010,B01000000,B10010010,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000100,B00000101,B00000011,B01100000,B01011110,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000010,B00000100,B10000001,B00100000,B01101100,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000010,B00000010,B11000000,B10110000,B00100000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000001,B00000011,B01000000,B10010000,B00110000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000001,B10000001,B01100000,B01011000,B00010000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B10000001,B10100000,B11010000,B00110000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B11000000,B10010000,B10010000,B00100000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B01000000,B01011001,B00100000,B01000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00100000,B01001011,B01100000,B01000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00110000,B00101110,B01000000,B10000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00010000,B00110110,B11000001,B10000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00011000,B00010000,B10000001,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00001000,B00001001,B00000011,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00001100,B00001001,B00000010,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00000100,B00000110,B00000110,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00000010,B00000110,B00000100,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00000011,B00000000,B00001000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00000001,B00000000,B00001000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00000001,B10000000,B00010000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00000000,B10000000,B00110000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00000000,B01000000,B00100000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00000000,B01000000,B01100000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00000000,B00100000,B01000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00000000,B00110000,B10000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00000000,B00011001,B10000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,
    B00000000,B00000000,B00000000,B00000000,B00001110,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000,B00000000
  };

  const unsigned char * const custom_bootscreen_animation[] PROGMEM = {
    custom_start_bmp1, custom_start_bmp2, custom_start_bmp3, custom_start_bmp4, custom_start_bmp
  };

#endif
