/**
 * Marlin 3D Printer Firmware
 * Copyright (C) 2016, 2017 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (C) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

/**
 * servo.h - Interrupt driven Servo library for Arduino using 16 bit timers- Version 2
 * Copyright (c) 2009 Michael Margolis.  All right reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#pragma once

/**
 * Based on "servo.h - Interrupt driven Servo library for Arduino using 16 bit timers -
 *           Version 2 Copyright (c) 2009 Michael Margolis.  All right reserved.
 *
 * The only modification was to update/delete macros to match the LPC176x.
 *
 */

#include <Servo.h>

class MarlinServo: public Servo {
  public:
  void move(const int value) {
    constexpr uint16_t servo_delay[] = SERVO_DELAY;
    static_assert(COUNT(servo_delay) == NUM_SERVOS, "SERVO_DELAY must be an array NUM_SERVOS long.");

    if (this->attach(servo_info[this->servoIndex].Pin.nbr) >= 0) {    // try to reattach
      this->write(value);
      safe_delay(servo_delay[this->servoIndex]); // delay to allow servo to reach position
      #if ENABLED(DEACTIVATE_SERVOS_AFTER_MOVE)
        this->detach();
      #endif
    }

  }
};

#define HAL_SERVO_LIB MarlinServo
